/*
 * Decompiled with CFR 0.152.
 */
package com.odinokland.constantmusic.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    private static final int BIG_BUTTON_WIDTH = 310;
    private static final int SMALL_BUTTON_WIDTH = 150;
    private static final int DEFAULT_ITEM_HEIGHT = 25;
    private final Screen screen;

    public OptionsList(Minecraft minecraft, int width, int height, int headerHeight, int footerHeight, Screen screen) {
        super(minecraft, width, height, headerHeight, height - headerHeight - footerHeight, 25);
        this.f_93394_ = false;
        this.screen = screen;
    }

    public void addBig(OptionInstance<?> optionInstance) {
        this.m_7085_((AbstractSelectionList.Entry)OptionEntry.big(this.f_93386_.f_91066_, optionInstance, this.screen));
    }

    public void addSmall(OptionInstance<?> ... optionInstances) {
        for (int i = 0; i < optionInstances.length; i += 2) {
            OptionInstance<?> optionInstance = i < optionInstances.length - 1 ? optionInstances[i + 1] : null;
            this.m_7085_((AbstractSelectionList.Entry)OptionEntry.small(this.f_93386_.f_91066_, optionInstances[i], optionInstance, this.screen));
        }
    }

    public void addSmall(List<AbstractWidget> list) {
        for (int i = 0; i < list.size(); i += 2) {
            this.addSmall(list.get(i), i < list.size() - 1 ? list.get(i + 1) : null);
        }
    }

    public void addSmall(AbstractWidget abstractWidget, AbstractWidget abstractWidget2) {
        this.m_7085_((AbstractSelectionList.Entry)Entry.small(abstractWidget, abstractWidget2, this.screen));
    }

    public int m_5759_() {
        return 310;
    }

    public AbstractWidget findOption(OptionInstance<?> optionInstance) {
        for (Entry entry : this.m_6702_()) {
            if (!(entry instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)entry;
            AbstractWidget abstractWidget = optionEntry.options.get(optionInstance);
            if (abstractWidget == null) continue;
            return abstractWidget;
        }
        return null;
    }

    public Optional<GuiEventListener> getMouseOver(double d, double e) {
        for (Entry entry : this.m_6702_()) {
            for (GuiEventListener guiEventListener : entry.m_6702_()) {
                if (!guiEventListener.m_5953_(d, e)) continue;
                return Optional.of(guiEventListener);
            }
        }
        return Optional.empty();
    }

    protected static class OptionEntry
    extends Entry {
        final Map<OptionInstance<?>, AbstractWidget> options;

        private OptionEntry(Map<OptionInstance<?>, AbstractWidget> map, Screen screen) {
            super((List<AbstractWidget>)ImmutableList.copyOf(map.values()), screen);
            this.options = map;
        }

        public static OptionEntry big(Options options, OptionInstance<?> optionInstance, Screen screen) {
            return new OptionEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionInstance, (Object)optionInstance.m_231507_(options, 0, 0, 310)), screen);
        }

        public static OptionEntry small(Options options, OptionInstance<?> optionInstance, OptionInstance<?> optionInstance2, Screen screen) {
            AbstractWidget abstractWidget = optionInstance.m_231507_(options, 0, 0, 150);
            return optionInstance2 == null ? new OptionEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionInstance, (Object)abstractWidget), screen) : new OptionEntry((Map<OptionInstance<?>, AbstractWidget>)ImmutableMap.of(optionInstance, (Object)abstractWidget, optionInstance2, (Object)optionInstance2.m_231507_(options, 0, 0, 150)), screen);
        }
    }

    protected static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> children;
        private final Screen screen;
        private static final int X_OFFSET = 160;

        Entry(List<AbstractWidget> list, Screen screen) {
            this.children = ImmutableList.copyOf(list);
            this.screen = screen;
        }

        public static Entry big(List<AbstractWidget> list, Screen screen) {
            return new Entry(list, screen);
        }

        public static Entry small(AbstractWidget abstractWidget, AbstractWidget abstractWidget2, Screen screen) {
            return abstractWidget2 == null ? new Entry((List<AbstractWidget>)ImmutableList.of((Object)abstractWidget), screen) : new Entry((List<AbstractWidget>)ImmutableList.of((Object)abstractWidget, (Object)abstractWidget2), screen);
        }

        public void m_6311_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            int p = 0;
            int q = this.screen.f_96543_ / 2 - 155;
            for (AbstractWidget abstractWidget : this.children) {
                abstractWidget.m_264152_(q + p, j);
                abstractWidget.m_88315_(guiGraphics, n, o, f);
                p += 160;
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }
}

